// DatabaseLoadExperimenterPlugin.cpp starts

#include <OS.h>
#include "DatabaseLoadExperimenterPlugin.h"
#include "Debug.h"
#include "UserEnvMessage.h"
#include "PluginSettingsNames.h"
#include "DatabaseMessage.h"
#include "DatabaseFieldNames.h"

ExperimenterPlugin *instantiate_exp(PortMessage *expRatPort,
	PortMessage *envExpPort, DatabaseMessage *dbMsg, UserEnvMessage *userEnvMsg,
      		DebugServer *bugServer) {
   return new DatabaseLoadExperimenterPlugin(expRatPort, envExpPort, dbMsg,
   		userEnvMsg, bugServer);
}

/*******************************************************
* Created: 11/2/00, CGP
* 	Database load experimenter. Creates a static set of test data for database.
* Changes
*	CGP; 11/5/00; Modified to use unified API for experimenter.
*******************************************************/

DatabaseLoadExperimenterPlugin::DatabaseLoadExperimenterPlugin(PortMessage *expRatPort,
	PortMessage *envExpPort, DatabaseMessage *dbMsg, UserEnvMessage *userEnvMsg,
      		DebugServer *bugServer):
	ExperimenterPlugin(expRatPort, envExpPort, dbMsg, userEnvMsg, bugServer)
{
	// temporary
	settings = new BMessage();
	
	// create default plugin settings, if none given
	if (settings->CountNames(B_ANY_TYPE) == 0) {
		Debug('n', "DatabaseLoadExperimenterPlugin::DatabaseLoadExperimenterPlugin: Null default settings");
		this->settings = new BMessage();
		this->settings->AddInt16(NUMBER_OF_MAZE_ARMS, 8);
	} // default constructor already established value for this->settings otherwise
}

DatabaseLoadExperimenterPlugin::~DatabaseLoadExperimenterPlugin()
{
}

void DatabaseLoadExperimenterPlugin::PLUGIN_RunTrial()
{
	Debug('n', "DatabaseLoadExperimenterPlugin::PLUGIN_RunTrial: Adding records");
	
	// Add a few test records to performance database
	BMessage *perfDataRecord;
	int16 ratNo = 100;
	int foodFlag = 0;
	int recordNumber = 1;
	
	for (;;) {
		perfDataRecord = new BMessage();
		
		// Database only allows int16's right now as data type
		perfDataRecord->AddInt16(DBFLD_RECORD_TYPE, 1); // record type 1 is for DatabaseLoadExperimenter
		perfDataRecord->AddInt16(DBFLD_ARM_NUMBER, 7);
		perfDataRecord->AddInt16(DBFLD_RAT_NUMBER, ratNo);
		perfDataRecord->AddInt16(DBFLD_CONTAINED_FOOD, (foodFlag++) % 2);
		EXP_AddDatabaseRecord(perfDataRecord);
		
		delete perfDataRecord;
		
		if (recordNumber++ > 50) {
			break;
		}
	}
}

// DatabaseLoadExperimenterPlugin.cpp ends